function createQuestCaves()
	createBriefingInfoCaves()
end

function createBriefingInfoCaves()
	BriefingDestroyCaves = {}
	BriefingDestroyCaves.finished = SetupInteractiveObjects
	
	local page = 1
	
	BriefingDestroyCaves[page] = {}
	BriefingDestroyCaves[page].title = "Soldat"
	BriefingDestroyCaves[page].text = "Mein Herr! Ich habe eine Idee, wie wir uns gegen die Angriffe aus den Höhlen wehren können. @cr Wenn wir genügend Steine zusammen bekämen, könnte jemand mit Kenntnissen in der Sprengkunst die Höhlen verschütten."
	BriefingDestroyCaves[page].position = GetPosition("player1")
	
	page = page + 1
	
	BriefingDestroyCaves[page] = {}
	BriefingDestroyCaves[page].title = "Soldat"
	BriefingDestroyCaves[page].text = "Dadurch könnten wir dem Feind die Wege versperren und wären vor Angriffen aus den jeweiligen Richtungen sicher."
	
	StartBriefing(BriefingDestroyCaves)
end

function SetupInteractiveObjects()
	for i = 1,5,1 do
		Interactive.Setup( {
				Range = 1000,
				Name = "s_army"..i,
				Opener = {"Pilgrim"},
				Button = {
					{
						Triggers = {},
						Texture	 = "Research_Construction",
						Title	 = "Verschütten",
						Text	 = "Die Höhle verschütten um Angriffe aus dieser Richtung zu unterbinden.",
						Costs = {0,0,0,5000,0,0},
						Callback = function(IO,i,hero)
							--verschütten, Entities wegbewegen, UA dort zerstören, andere UAs verstärken, Steinpreis anheben
							local temptable = {string.gsub(IO.Name,"s_army","")}
							DestroyCave(tonumber(temptable[1]))
						end,
					},
				},
				DoNotShowAMarker = true,
				SingleUse = true,
			})
	end
end

function DestroyCave(_cavenumber)
	--Message("Debug: Du hast Hoehle ".._cavenumber.." zerstoert")
	villageAttackers[_cavenumber]:Destroy()
	for k,v in pairs(availableCaves) do
		if v == _cavenumber then
			table.remove(availableCaves,k)
		end
	end
	cavesdestroid = cavesdestroid + 1
	local rockpos = GetPosition("s_army".._cavenumber)
	Logic.CreateEntity(Entities.XD_Rock7,rockpos.X,rockpos.Y,0,0)
	Logic.CreateEffect(GGL_Effects.FXExplosion ,rockpos.X,rockpos.Y,0)
	local enttype = {Logic.GetPlayerEntitiesInArea(1, nil, rockpos.X, rockpos.Y, 600, 1)}
	while enttype[1] > 0 do
		if Logic.IsHero(enttype[2]) == 1 then
			SetPosition(enttype[2], GetPosition("herorespawn"))
		else
			Logic.DestroyEntity(enttype[2])
		end
		enttype = {Logic.GetPlayerEntitiesInArea(1, nil, rockpos.X, rockpos.Y, 300, 1)}
	end
	for _name,_table in pairs(Interactive.IO) do
		_table.Button[1].Costs[4] = _table.Button[1].Costs[4] + 5000
	end
end